/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMContents;
import filenet.vw.idm.toolkit.IVWIDMItem;

final class VWIDMContents
implements IVWIDMContents {
    protected static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static String m_className = "VWIDMContents";
    private IVWIDMItem[] m_contents = null;
    private int m_curRequest = 0;
    private int m_totalSize = 0;
    private int m_batchSize = 0;
    private int m_subFolderCount = 0;
    private int m_maxFilterFolderSize = 0;
    private boolean m_bMaxReached = false;

    protected VWIDMContents(IVWIDMItem[] wholeList, int maxFolderSize, boolean maxReached) {
        this.m_contents = wholeList;
        if (this.m_contents != null) {
            this.m_batchSize = this.m_totalSize = this.m_contents.length;
        }
        this.m_maxFilterFolderSize = maxFolderSize;
        this.m_bMaxReached = maxReached;
    }

    protected VWIDMContents() {
    }

    public boolean hasNext() {
        boolean res;
        String m_method = "hasNext";
        boolean bl = res = this.m_totalSize > 0 && this.m_curRequest < this.m_totalSize;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "hasNext=" + new Boolean(res).toString() + ", m_curRequest=" + Integer.toString(this.m_curRequest));
        }
        return res;
    }

    public int size() {
        return this.m_totalSize;
    }

    public int batchSize() {
        return this.m_batchSize;
    }

    public void getNextBatch() throws VWException {
        if (this.m_contents == null) {
            return;
        }
        if (this.m_curRequest >= this.m_totalSize) {
            return;
        }
        if (this.m_curRequest == 0) {
            this.m_curRequest = this.m_batchSize;
            return;
        }
    }

    public IVWIDMItem[] list() {
        return this.m_contents;
    }

    public void release() throws VWException {
        if (this.m_contents != null) {
            int len = this.m_contents.length;
            for (int i = 0; i < len; ++i) {
                this.m_contents[i] = null;
            }
            this.m_contents = null;
        }
    }

    public int getSubFolderCount() {
        return this.m_subFolderCount;
    }

    public int getFilterFolderMaxSize() {
        return this.m_maxFilterFolderSize;
    }

    public boolean reachedFilterFolderMaxSize() {
        return this.m_bMaxReached;
    }
}

